/*****************************************************************************/
/* Betriebssysteme I, Uni Potsdam, WS 97/98                                  */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                             T E S T S E M                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul TESTSEM, das nur aus der Dateien testsem.c besteht, realisiert  */
/* das in der Aufgabe 5 beschriebene Testprogramm.                           */
/*****************************************************************************/

/* INCLUDES */

#include "machine/screen.h"
#include "guard/syscall.h"
#include "guard/sema.h"
#include "thread/process.h"

/* DEFINES */

#define STACK_SIZE	4096

#define CUP	0x48
#define CLE 0x4b
#define CRI 0x4d
#define CDO 0x50

#define ESC 1

/* INTERNE FUNKTIONEN DES MODULS */

static void echo_input (void);

/* GLOBALE VARIABLEN DES MODULS */

static struct semaphore echo_sem;
static char echost[STACK_SIZE];
static int echopid;

/* IMPLEMENTIERUNG DER EXPORTIERTEN FUNKTION */

/* APPLICATION : Funktion, die von main gestartet wird und den Anwendungs-   */
/*               prozess implementiert.                                      */

#define RoWs 25
#define CoLumns 80
#define BlAck 0
#define LiGht_grey 6
#define AtTribute(bg,fg,blink) ((((blink) & 1) << 7) | (((bg) & 0x7) << 4) |\
                                ((fg) & 0xf))
void application (void)
 {
   int x, y;

   /* Bildschirm loeschen */

   for (y = 0; y < RoWs; y++)
      for (x = 0; x < CoLumns; x++)
         kshow (x, y, ' ', AtTribute (BlAck, LiGht_grey, 0));

   ksetpos (0, 0);
   kprintf ("Die Anwendung laeuft.\n");
   sys_sema_init (&echo_sem, 0);
   echopid = sys_create_process (echo_input, echost, STACK_SIZE);
   sys_sema_p (&echo_sem);
   kprintf ("...aber gleich nicht mehr.\n");
   kill_process (echopid);
   exit_process ();

 }

void echo_input (){
	int c;
	int x, y;

	kprintf ("echo running\n");

	for (;;) {
		c = sys_getchar ();
		if (c&0xff)
			kprintf ("%c", c&0xff);
		else {
			kgetpos (&x, &y);
			switch (c>>8) {
				case ESC:
					sys_sema_v (&echo_sem);
					break;
				case CUP:
					if (y) --y;
					break;
				case CDO:
					if (y < 24) ++y;
					break;
				case CLE:
					if (x) --x;
					break;
				case CRI:
					if (x < 79) ++x;
					break;
				default:
					break;
			}
			ksetpos (x, y);
		}
	}
}
