/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                        A P P L I C A T I O N                              */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul APPLICATION, das aus den Dateien APPL.H und APPL.C besteht,     */
/* implementiert die Anwendung des Systems.                                  */
/*****************************************************************************/

/* INCLUDES */

#include "machine/screen.h"
#include "thread/sched.h"
#include "thread/process.h"
#include "machine/cpu.h"
#include "guard/syscall.h"

/* DEFINES */

#define STACK_SIZE 4096
#define DELAY      100


/* INTERNE FUNKTIONEN DES MODULS */

static void proc1 (void);
static void proc2 (void);
static void proc3 (void);

/* GLOBALE VARIABLEN DES MODULS */

static char stack1[STACK_SIZE];
static char stack2[STACK_SIZE];
static char stack3[STACK_SIZE];

int pid[3];

/* IMPLEMENTIERUNG DER EXPORTIERTEN FUNKTION */

/* APPLICATION : Funktion, die von main gestartet wird und den Anwendungs-   */
/*               prozess implementiert.                                      */

#define RoWs 25
#define CoLumns 80
#define BlAck 0
#define LiGht_grey 7
#define AtTribute(bg,fg,blink) ((((blink) & 1) << 7) | (((bg) & 0x7) << 4) |\
                                ((fg) & 0xf))

void application (void)
 {
   /* int x, y;

    Bildschirm loeschen */
   /* for (y = 0; y < RoWs; y++)
      for (x = 0; x < CoLumns; x++)
	 kshow (x, y, ' ', AtTribute (BlAck, LiGht_grey, 0));
   ksetpos (0, 0);
   kprintf ("Die Anwendung laeuft.\n"); */
   
   sys_sema_p(&screen_sema);
   pid[0] = sys_create_process (proc1, stack1, STACK_SIZE);
   kprintf("app process (pid:0x%x) created...\n",pid[0]);
   pid[1] = sys_create_process (proc2, stack2, STACK_SIZE);
   kprintf("app process (pid:0x%x) created...\n",pid[1]);
   pid[2] = sys_create_process (proc3, stack3, STACK_SIZE);
   kprintf("app process (pid:0x%x) created...\n",pid[2]);
   sys_sema_v(&screen_sema);

   
   sys_exit_process ();     /* proc1, proc2 und proc3 laufen alleine weiter */
 }


/* IMPLEMENTIERUNGEN DER INTERNEN FUNKTIONEN */

/* PROC1 : Testprozess 1 der Anwendung                                      */

static void proc1 (void)
 {
   int i;
   int j;
   int sx,sy;

   for (i = 0;; i++)
    {
      for (j = 0; j < DELAY; j++);
      sys_sema_p(&screen_sema);
      kgetpos (&sx, &sy);
      ksetpos (10, 22);
      kprintf ("P1: %d", i);
      ksetpos (sx, sy);
      sys_sema_v(&screen_sema);
      if (i % 1 == 0)
	 	sys_resume ();
    }
   sys_exit_process ();
 }

/* PROC2 : Testprozess 2 der Anwendung                                      */

static void proc2 (void)
 {
   int i;
   int j;
   int sx,sy;

   for (i = 0;; i++)
    {
      for (j = 0; j < DELAY; j++);
      sys_sema_p(&screen_sema);
      kgetpos (&sx, &sy);
      ksetpos (30, 22);
      kprintf ("P2: %d", i);
      ksetpos (sx, sy);
      sys_sema_v(&screen_sema);
      if (i % 2 == 0)
	 	sys_resume ();
    }
   sys_exit_process ();
 }

/* PROC3 : Testprozess 3 der Anwendung                                      */

static void proc3 (void)
 {
   int i;
   int j;
   int sx,sy;

   for (i = 0;i<2000; i++)
    {
      for (j = 0; j < DELAY; j++);
      sys_sema_p(&screen_sema);
      kgetpos (&sx, &sy);
      ksetpos (50, 22);
      kprintf ("P3: %d", i);
      kgetpos (&sx, &sy);
      sys_sema_v(&screen_sema);
      if (i % 3 == 0)
	 	sys_resume ();
      if (i == 500) {
        sys_sema_p(&screen_sema);
	 	sys_kill_process (pid[0]);
        sys_sema_v(&screen_sema);
	  }
      if (i == 1000) {
      	sys_sema_p(&screen_sema);
	 	sys_kill_process (pid[1]);
        sys_sema_v(&screen_sema);		
	  }
    }
   sys_exit_process ();
 }

