
#include "thread/sched.h"
#include "guard/lock.h"
#include "objects/list.h"
#include "machine/pcb.h"
#include "machine/disp.h"
#include "machine/screen.h"
#include "machine/cpu.h"
#include "thread/process.h"


static struct list ready_list;

static struct pcb* life = 0;


/* scheduler initialisieren */
void init_sched(void)
{
 life=0;
 list_init(&ready_list);	/* intitialisiere ready_list */
}

/* liefert life-pointer zurueck */
struct pcb* me (void)
{
 return life;
}

void run (struct pcb* proc)
{
 life=proc;				/* neuer life pointer = proc */
 life->state=RUNNING;	/* und neuen life state auf RUNNING setzen */
}

void ready (struct pcb* proc)
{
  proc->state=READY;		/* proc state auf READY setzen */
  enqueue(&ready_list, &proc->chain);	/* und in ready_list einfuegen */
}

void remove (struct pcb* proc)
{
 struct pcb* p=0;
 int i;
 
 for (i=0;i<=MAXPROCS;i++)     /* maximal MAXPROCS-mal suchen */
 {
  p=(struct pcb*)dequeue(&ready_list); /* einen pcb aus readylist holen */
  if (p==proc) return;
  enqueue(&ready_list,&p->chain); /* sonst pcb wieder in readylist und weiter */
 }
}

void resume (void)
{
 struct pcb* p=life;                 /* aktuellen prozess */

 if (!p) return;

 ready(p);    			/* in ready list stecken */

 life=(struct pcb*)dequeue(&ready_list);  /* neuen prozess holen */

 run(life);
 
 dispatch(&p->regs,&life->regs);  /* und los */
}

void remove_myself (void)
{
 struct pcb* p = life;
 life=(struct pcb*)dequeue(&ready_list);	/* naechsten process holen */
 run(life);				/* auf RUNNING setzen */
 dispatch(&p->regs,&life->regs);	/* und dahin wechseln */
}

void schedule (void)
{
 enter();
 life=(struct pcb*)dequeue(&ready_list);  /* neuen prozess holen */
 run(life);
 go(&life->regs);  /* und los */
}

