
#include "thread/process.h"

#include "objects/list.h"
#include "machine/pcb.h"
#include "machine/disp.h"
#include "machine/cpu.h"
#include "machine/screen.h"
#include "thread/sched.h"
#include "guard/lock.h"
#include "guard/sema.h"

static struct pcb proctable[MAXPROCS];

static struct list free_list;


void init_process (void)
{
 int i;
 
 list_init(&free_list);	/* initialisiere free_list */
 
 for (i=0;i<MAXPROCS;i++)
 {
  list_element_init(&proctable[i].chain);	/* jedes element inititalisieren */
  enqueue(&free_list,&proctable[i].chain);	/* und in free_list einfuegen */
 } 
}

/* der process wrapper */
void lifter (void (*code)(void))
{
 leave();
 (*code)();
 exit_process();
}

int create_process (void (*code)(void), char* stack, int stack_size)
{
 struct pcb* p;
 int pid=0;

 p=(struct pcb*)dequeue(&free_list); /* aus free list raus */
 
 settle(&p->regs,lifter,code,stack,stack_size);

 ready(p); /* in ready list rein */
 
 pid = p - proctable;     /* pid bestimmen */
 
 return pid;
}

void kill_process (int pid)
{
 struct pcb* p;
 
 p=&proctable[pid];      /* prozess mit der pid raussuchen */
 
 if ( p->state == WAITING )
	sema_remove_proc (p); /* aus wait list raus... */
 else
  	remove(p); /* ...oder aus ready list raus */
  
 enqueue(&free_list,&p->chain); /* in free list rein */
 
}

void exit_process (void)
{
 struct pcb* p;
 
 p = me();
 
 enqueue(&free_list,&p->chain); /* in free list rein */

 remove_myself();
}

struct pcb* pid2pcb(int pid)
{
 return &proctable[pid];
}
