;******************************************************************************
;* Betriebssysteme I, Uni-Magdeburg, SS 97                                    *
;*----------------------------------------------------------------------------*
;*                                                                            *
;*                        S T A R T U P . A S M                               *
;*                                                                            *
;*----------------------------------------------------------------------------*
;* 'startup' ist der Eintrittspunkt des eigentlichen Systems. Die Umschaltung *
;* in den 'Protected Mode' ist bereits erfolgt. Es wird alles vorbereitet,    *
;* damit so schnell wie moeglich die weitere Ausfuehrung durch C-Code erfol-  *
;* gen kann.                                                                  *
;******************************************************************************

%include "include/csym.inc"	; Innerhalb des Include-Files 'csym.m4'
				; wird das Macro CSYM(name) definiert,
				; das dem uebergebenen Symbolnamen in
				; Abhaegigkeit vom verwendeten Generierungs-
				; system einen Unterstrich ('_') voranstellt.

;
;   System
;

csym idt
csym main
csym guardian
			
[GLOBAL startup]
[GLOBAL idt]

[EXTERN main]
[EXTERN guardian]


[SECTION .text]

startup:
	
; GCC-kompilierter Code erwartet das so.

	cld
	
; Globales Datensegment

	mov	ax,0x10
	mov	ds,ax
	mov	es,ax
	mov	fs,ax
	mov	gs,ax
	
; Stack festlegen
	
	mov	ss,ax
	mov	esp,init_stack+4096

; Unterbrechungsbehandlung sicherstellen

	call	setup_idt
	call	reprogram_pics
	
; Aufruf des C-Codes

	call	main		; C/C++ Level System
	hlt

; Default Interrupt Behandlung

; Spezifischer Kopf der Unterbrechungsbehandlungsroutinen

%macro wrapper 1
wrapper_%1:
	push	eax
	mov	al,%1
	jmp	wrapper_body
%endmacro

; ... wird automatisch erzeugt.
%assign i 0
%rep 256
wrapper i
%assign i i+1
%endrep

; Gemeinsamer Rumpf
wrapper_body:
	cld			; das erwartet der gcc so.
	push	ecx		; Sichern der fluechtigen Register
	push	edx
	and	eax,0xff	; Der generierte Wrapper liefert nur 8 Bits
	push	eax		; Nummer der Unterbrechung uebergeben
	call	guardian
	add	esp,4		; Parameter vom Stack entfernen
	pop	edx		; fluechtige Register wieder herstellen
	pop	ecx
	pop	eax
	iret			; fertig!

;
; setup_idt
;
; Relokation der Eintraege in der IDT und Setzen des IDTR

setup_idt:
	mov	eax,wrapper_0	; ax: niederwertige 16 Bit
	mov	ebx,eax
	shr	ebx,16		; bx: hoeherwertige 16 Bit
	mov	ecx,256		; Zaehler
.loop:	add	[idt+8*ecx+0],ax
	adc	[idt+8*ecx+6],bx
	dec	ecx
	jge	.loop

	lidt	[idt_descr]
	ret

;
; reprogram_pics
;
; Neuprogrammierung der PICs (Programmierbare Interrupt-Controller), damit
; alle 15 Hardware-Interrupts nacheinander in der idt liegen.

reprogram_pics:	
	mov	al,0x11
	out	0x20,al
	call	delay
	out	0xa0,al
	call	delay
	mov	al,0x20
	out	0x21,al
	call	delay
	mov	al,0x28
	out	0xa1,al
	call	delay
	mov	al,0x04
	out	0x21,al
	call	delay
	mov	al,0x02
	out	0xa1,al
	call	delay
	mov	al,0x01
	out	0x21,al
	call	delay
	out	0xa1,al
	call	delay

	mov	al,0xff		; Hardware-Interrupts durch PICs
	out	0xa1,al		; ausmaskieren. Nur der Interrupt 2,
	call	delay		; der der Kaskadierung der beiden
	mov	al,0xfb		; PICs dient, ist erlaubt.
	out	0x21,al

	ret

; delay
;
; Kurze Verzoegerung fuer in/out Befehle.

delay:
	jmp	.L2
.L2:	ret

[SECTION .data]
	
;  'interrupt descriptor table' mit 256 Eintraegen.

idt:

%macro idt_entry 1
	dw	(wrapper_%1 - wrapper_0) & 0xffff
	dw	0x0008
	dw	0x8e00
	dw	((wrapper_%1 - wrapper_0) & 0xffff0000) >> 16
%endmacro

; ... wird automatisch erzeugt.

%assign i 0
%rep 256
idt_entry i
%assign i i+1
%endrep

idt_descr:
	dw	256*8-1		; idt enthaelt 256 Eintraege
	dd	idt


;   Stack und interrupt descriptor table im BSS Bereich

[SECTION .bss]

init_stack:
	resb	4096

