#include "machine/screen.h"
#include "thread/sched.h"
#include "thread/process.h"
#include "machine/cpu.h"
#include "machine/pic.h"
#include "machine/plug.h"
#include "machine/timer.h"
#include "device/keybd.h"
#include "device/watch.h"
#include "user/appl.h"
#include "guard/lock.h"
#include "guard/syscall.h"
#include "fun.h"

#define	PROCSTACKSIZE	(8*1024)


/* jeder braucht hier und da mal nen schluck speicher */
unsigned char	jast_memory[65536];		
unsigned char	save_pal[16],
jast_pal[8] = {	COLOR_FOREGROUND_BLACK,
				COLOR_FOREGROUND_BLUE,
				COLOR_FOREGROUND_CYAN,
				COLOR_FOREGROUND_LIGHTBLUE,
				COLOR_FOREGROUND_LIGHTCYAN,
				COLOR_FOREGROUND_WHITE,
				COLOR_FOREGROUND_LIGHTRED,
				COLOR_FOREGROUND_YELLOW };

unsigned char	jast_stack[5*PROCSTACKSIZE];

void __main ()
{
}



/* erste function in main */
void jastOS_startup()
{
	/* ein kleiner intro(bald)fader */
	const int fadewidth = 5;		/* breite des fades */
	int pos,x,y,fade;
	unsigned char	*temp;

	for (pos = 0; pos < 16; pos++)
		save_pal[pos] = kreadattrcontr(pos);
		
	for (pos = 0; pos < 16; pos++)
		kwriteattrcontr(pos,save_pal[jast_pal[pos & 0x07]]);
	
	klearscreen(0,0);				/* bildschirm loeschen */
	kopyfont((void*)jast_memory);	/* font aus der 2.bitplane des ega kopieren */
	kputBigString(8,8,"JAST OS",219,0, jast_memory);	/* groooossen font malen */
	
	/* fade von links nach rechts ueber den bildschirm laufen lassen */
	for ( pos = -fadewidth; pos < 80+fadewidth; pos++ ) {
	
		kwaitvretrace();			/* mit retrace synchronisieren (kein flackern, konst. 70Hz) */
		
		/* jetzt den bildschirm spaltenweise abklappern */
		for ( x = 0; x < 80; x++ ) {		
			temp = (unsigned char*)CGA_BASE + (x << 0x01) + 1;
			for ( y = 0; y < 25; y++ ) {
				fade = abs(pos-x);		
				if ( fade > fadewidth )	/* position in fade-bereich? */
					*temp = COLOR_FOREGROUND_BLACK;	/* nein, dann schwarz */
				else
					*temp = 5-fade; /* sonst nicht */
				temp += 160;						/* eine zeile weiter */
			}
		}
	}
	
	klearscreen(' ',COLOR_DEFAULT);	/* bildschirm loeschen */
	kputBigString(8,8,"JAST  S",32,48, jast_memory);
	ksetpos(0,0);					/* position auf 0,0 setzen */
	kputs("jast OS v8.1");			/* string ausgeben */
	ksetpos(0,1);
	InitFun();

}


/* unser idle process, malt in die obere linke ecke einen
   blinkenden stern */
void Idle()
{
	static int ic;
	int x;
	
	while ( 1 ) {
		if ( ((ic++) >> 3) & 1 ) {
		 for ( x = 0; x < 8; x++ ) 
		 	if ( x == ( (ic>>2) & 0x07) )
				kshow(72+x,0,'*',COLOR_DEFAULT);
			else
				kshow(72+x,0,' ',COLOR_DEFAULT);
		 }
		sys_resume();                               /* und resumen...*/
	}

}

void Fun()
{
	static int cnt;
	
	while (1) {
		sys_sema_p(&screen_sema);
		DoFun(cnt++);
		sys_sema_v(&screen_sema);
		sys_resume();
	}
}

void Shell()
{
	static int xpos = 0;
	int c,sx,sy;
	while (1) {
 	  c=sys_getchar();
  	  if ( xpos < 79 ) { 
	  	sys_sema_p(&screen_sema);
	    kgetpos(&sx,&sy);
  	  	ksetpos(xpos++,24);
  	  	kprintf("%c",c);
		ksetpos(sx,sy);
		sys_sema_v(&screen_sema);
	  }
  	  sys_resume();		
 	}
}



int main ()
{
 int pid1, pid2, pid3, pid4;
 
 ksetpage(0);				/* CRTBasePtr auf erste Bildschirmspalte setzen */

 jastOS_startup();			/* startup laufen lassen */
 
 init_lock();
 kprintf("locking mechanism initialized...\n");
 
 sys_sema_init(&screen_sema,1); /* bildschirm semaphore initialisieren */

 init_plug();
 kprintf("plug initialized...\n");
 init_keyboard();
 kprintf("keyboard initialized...\n");
 init_watch();
 kprintf("watch initialized...\n");
 
 kprintf("Init scheduler...\n");
 init_sched();
 kprintf("Init process...\n");
 init_process();
 
 kprintf("Create idle process...\n");
 pid1 = sys_create_process(Idle,jast_stack,PROCSTACKSIZE);

 kprintf("Create fun process...\n");
 pid2 = sys_create_process(Fun,jast_stack+PROCSTACKSIZE,PROCSTACKSIZE);

 kprintf("Create shell process...\n");
 pid3 = sys_create_process(Shell,jast_stack+2*PROCSTACKSIZE,PROCSTACKSIZE);

 kprintf("Create application process...\n");
 pid4 = sys_create_process(application,jast_stack+3*PROCSTACKSIZE,PROCSTACKSIZE);

 enable_int();
 kprintf("interrupts enabled...\n");
 
 kprintf("\nStarting schedule...\n\n");
 schedule();

 return(0);
}
