
#include "machine/ioport.h"
#include "machine/timer.h"
#include "machine/pic.h"


void timer_set (int us)
{
 int timer_value;


 forbid_int(HW_INT_TIMER); /* timer interrupt ausschalten */

 outb(0x43,0x34); /* 1. pit, zaehler 0, lo dann hi, modus 2, binaer 16 bit */
 timer_value = ( us * 1000 / 838 );     /* in zaehler wert umrechnen */
 outb(0x40,timer_value & 0x00FF);          /* lo byte */
 outb(0x40,(timer_value >> 8) & 0x00FF); /* hi byte */

 allow_int(HW_INT_TIMER); /* timer interrupt wieder erlauben */
}

