#include "machine/screen.h"
#include "guard/sema.h"
#include <stdarg.h>

extern void scrollup(); /* externe assembler funktion */
extern unsigned int CRTBasePtr;

char	hextab[16] = "0123456789ABCDEF"; /* ziffer->zeichen uebersetzungstabelle */

struct semaphore screen_sema;  /* semaphore zur bildschirm synchronisation */

int kshow(int x, int y, char c, unsigned char attrib)
{
 char* screen_ptr=(char*)CRTBasePtr;
 unsigned int offset;

 if ((x>=0) && (x<=79) && (y>=0) && (y<=24)) /* pruefen ob gueltige position */
 {
  offset = (y*80+x) << 1; /* offset=(y*80+x)*2 */

  screen_ptr[offset] = c; /* erstes byte: zeichen */
  screen_ptr[offset+1] = attrib; /* zweites byte: attribut */

  return 0;
 }

 return -1; /* keine gueltige cursor position */
}


char kgetChar(int x, int y)
{
 char* screen_ptr=(char*)CRTBasePtr;
 unsigned int offset;

 if ((x>=0) && (x<=79) && (y>=0) && (y<=24)) /* pruefen ob gueltige position */
 {
  offset = (y*80+x) << 1; /* offset=(y*80+x)*2 */

  return screen_ptr[offset];
 }

 return -1; /* keine gueltige cursor position */
}

unsigned char kgetAttrib(int x, int y)
{
 char* screen_ptr=(char*)CRTBasePtr;
 unsigned int offset;

 if ((x>=0) && (x<=79) && (y>=0) && (y<=24)) /* pruefen ob gueltige position */
 {
  offset = (y*80+x) << 1; /* offset=(y*80+x)*2 */

  return screen_ptr[offset+1];
 }

 return -1; /* keine gueltige cursor position */
}



void kshow2(int* x, int* y, char c, unsigned char attrib)
{ 
    unsigned char a;
	
	if ( !c )		/* nullbytes werden nicht ausgegeben */
	return;
	
	a = kgetAttrib(*x,*y);
	a &= 0xF0;
	attrib &= 0x0F;

    if ( kshow(*x,*y,c,attrib | a) == -1 )
	return;
    
    if ( *x < 79 ) /* solang nicht ueber 80. spalte */
	(*x)++;    /* eine spalte weiter */
    else {
	*x = 0;    /* sonst eine zeile weiter */
	(*y)++;
    };

    if ( *y > 24 ) { /* wenn in 26. zeile... */
	scrollup();  /* ...dann eine zeile hochscrollen... */
	*y = 24;     /* ..und wir sind wieder in der 25. zeile */
    }
  
/*    ksetpos(*x,*y); */
}


void kgetpos(int* x, int* y)
{
 unsigned int offset;
 unsigned char high,low;


 outb(PORT_REG_INDEX, REGINDEX_CURSOR_HIGH); /* hi-byte lesen */
 high=inb(PORT_REG_DATA);
 outb(PORT_REG_INDEX, REGINDEX_CURSOR_LOW);  /* lo-byte lesen */
 low=inb(PORT_REG_DATA);

 offset = (high << 8) | low; /* offset aus hi-byte lo-byte zusammenbasteln */
 *x = offset % 80;
 *y = offset / 80;
}


void ksetpos(int x, int y)
{
 unsigned int offset;
 unsigned char high,low;

 offset = y*80+x;
 high = offset >> 8; /* hi-byte des offset-words */
 low = offset; /* lo-byte des offset-words */

 outb(PORT_REG_INDEX, REGINDEX_CURSOR_HIGH); /* hi-byte schreiben */
 outb(PORT_REG_DATA, high);
 outb(PORT_REG_INDEX, REGINDEX_CURSOR_LOW); /* lo-byte schreiben */
 outb(PORT_REG_DATA, low);
}

void kputs(const char* text)
{
 int x,y;
 
 kgetpos(&x,&y); /* aktuelle cursor position holen */
 
 while (*text != 0) /* solnage kein kein null-byte gefunden wird */
 {
  kshow2(&x,&y,*text,COLOR_DEFAULT); /* zeichen ausgeben */
  text++; /* naechstes zeichen */
 }

 ksetpos(x,y); /* cursor-position ans ende setzen */

}


/* gibt einen 'int' dezimal an position x,y aus */
void PrintDec(int* x, int* y, int dec)
{
    if ( dec < 0 ) {
		kshow2(x,y,'-',COLOR_DEFAULT);
		dec = -dec;
	}
	
	if ( dec > 9 )             		/* wenn dec groesser 9 waere -> teilen und weiter */
		PrintDec(x,y,dec / 10); 	/* rekursion rulez */
	
    kshow2(x,y,hextab[dec % 10],COLOR_DEFAULT); /* sonst zeichen setzen */
}


/* gibt einen 'int' zu beliebiger basis 2^bits ( bits in [1..4] ) aus */
void PrintExp2(int* x, int* y, unsigned int num, unsigned int bits)
{
    if ( num > ((1 << bits)-1) )      /* wenn num groesser 2^bits - 1 -> shiften und weiter */
	PrintExp2(x,y,num >> bits,bits);  /* und zwar rekusiv */

    kshow2(x,y,hextab[num & ((1 << bits)-1)],COLOR_DEFAULT); /* sonst zeichen setzen */
}


void kprintf(const char* format, ...)
{
    va_list	paramList;
    int		x, y;
  
    va_start(paramList, format);	/* parameterliste anfangen bei format */
    kgetpos(&x, &y);				/* akt. position holen */
    
    while (*format) {				/* steht noch was drin? */
    
		switch (*format) {		

		case '\n' :				/* '\n' gefunden? */
	    
			if ( y < 24 ) 		/* schon am unteren bs-rand? */
		    	y++;			/* now, dann normal incr */
			else {
		    	scrollup();		/* sonst scrollup und... */
		    	y = 24;			/* ...line auf max */
			}
			
			x = 0;				/* x ist sowieso dann 0 */
			break;

	    case '%' :    				/* '%' gefunden? */
	
			switch (*(++format)) {	/* dann naechstes zeichen checken */
		
		    case 'c' :			/* char ausgeben */
				kshow2(&x,&y,va_arg(paramList, char),COLOR_DEFAULT);
    			break;
	
		    case 's' :			/* string ausgeben */
				kputs(va_arg(paramList, char*));
				kgetpos(&x,&y);
				break;
		
		    case 'x' :			/* hex ausgeben */
				PrintExp2(&x,&y,va_arg(paramList, int),4);
				break;
		
		    case 'd' :			/* dezimal ausgeben */
				PrintDec(&x,&y,va_arg(paramList, int));
				break;
		
		    case 'o' :			/* octal ausgeben */
				PrintExp2(&x,&y,va_arg(paramList, int),3);
				break;
			
		    case 'b' :			/* binaer ausgeben */
				PrintExp2(&x,&y,va_arg(paramList, int),1);
				break;
		
    		default :			/* sonst '%' ausgeben und... */
				kshow2(&x,&y,'%',COLOR_DEFAULT);
				format--;		/* ...ein zeichen zurueck setzen */
			
			}
		
			break;		
			
	    default:
			
			kshow2(&x,&y,*format,COLOR_DEFAULT);

		}
	
		format++;

    }
    
    ksetpos(x,y);
    va_end(paramList);
}

void ksetpage(int page)
{
	CRTBasePtr = CGA_BASE + page*4000;	/* pro page 80*25*2 bytes */
}


void kputBigLetter(int x, int y, char c, int fillc, int attrib, void* fnttbl)
{
	int 			x1,y1;
	unsigned char*	letter;
	
	/* zeiger auf daten des buchstabens in fonttable holen */	
	letter = &((unsigned char*)fnttbl)[32*(int)c];
	
	for ( y1 = 0; y1 < 16; y1++ )		/* zeichen ist 16 pixel hoch */
	 for ( x1 = 0; x1 < 8; x1++ ) {		/* und 8 pixel breit */
	
	  if ( letter[y1] & ( 1 << (7-x1) ) )	/* wenn bit gesetzt */
	  	kshow(x+x1,y+y1,fillc,attrib);	/* zeichen als "pixel" malen */
	
	}	
	
}


void kputBigString(int x, int y, char* text, int fillc, int attrib, void* fnttbl)
{
	
	while ( *text ) {	/* null-terminiert */
		
	 kputBigLetter(x,y,*text++,fillc,attrib,fnttbl); /* buchstaben ausgeben */
	 x += 9;
	 
	}
}


void kinitGraphRect( void* fontbuf, int x1, int y1, int width, int height, unsigned char attr )
{	
	int 	x,y,offs = 0;
	unsigned char	a;
	
	kgetfontaccess();
	klearfont(fontbuf);
	kreleasefontaccess();
	attr |= 0x08;
	for ( y = y1; y < y1+height; y++ )
		for ( x = x1; x < x1+width; x++ ) {
			a = kgetAttrib(x,y) & 0xF0;
			kshow(x,y,offs++,a | (attr & 0x0F));
		}
}
