; INCLUDES

%include "include/csym.inc"	; Innerhalb des Include-Files 'csym.m4'
				; wird das Macro CSYM(name) definiert,
				; das dem uebergebenen Symbolnamen in
				; Abhaegigkeit vom verwendeten Generierungs-
				; system einen Unterstrich ('_') voranstellt.

%define CGA_BASE 			0xb8000
%define PORT_REG_INDEX 			0x3d4
%define PORT_REG_DATA 			0x3d5
%define REGINDEX_CURSOR_HIGH 	14
%define REGINDEX_CURSOR_LOW 	15

%define CRTSTATUS				0x3DA
%define	CRTATTR					0x3C0
%define CRTADR					0x3D4
%define EGAVGA_SEQ				0x3C4
%define EGAVGA_GC				0x3CE

%define COLOR_FOREGROUND_BLACK		0
%define COLOR_FOREGROUND_BLUE		1
%define COLOR_FOREGROUND_GREEN		2
%define COLOR_FOREGROUND_CYAN		3
%define COLOR_FOREGROUND_RED		4
%define COLOR_FOREGROUND_MAGENTA	5
%define COLOR_FOREGROUND_BROWN		6
%define COLOR_FOREGROUND_LIGHTGREY	7
%define COLOR_FOREGROUND_DARKGREY	8
%define COLOR_FOREGROUND_LIGHTBLUE	9
%define COLOR_FOREGROUND_LIGHTGREEN	10
%define COLOR_FOREGROUND_LIGHTCYAN	11
%define COLOR_FOREGROUND_LIGHTRED	12
%define COLOR_FOREGROUND_LIGHTMAGENTA	13
%define COLOR_FOREGROUND_YELLOW		14
%define COLOR_FOREGROUND_WHITE		15
%define COLOR_BACKGROUND_BLACK		0
%define COLOR_BACKGROUND_BLUE		16
%define COLOR_BACKGROUND_GREEN		32
%define COLOR_BACKGROUND_CYAN		48
%define COLOR_BACKGROUND_RED		64
%define COLOR_BACKGROUND_MAGENTA	80
%define COLOR_BACKGROUND_BROWN		96
%define COLOR_BACKGROUND_LIGHTGREY	112
%define COLOR_BLINK			128

%define COLOR_DEFAULT	(COLOR_BACKGROUND_BLUE + COLOR_FOREGROUND_RED)

; EXPORTIERTE FUNKTIONEN

csym 		klearscreen
csym 		scrollup
csym		CRTBasePtr

csym		kwaitvretrace
csym		kopyfont
csym		kgetfontaccess
csym		kreleasefontaccess
csym		kfontputpixel
csym		klearfont
csym		kselectcharmaps

csym		kwriteattrcontr
csym		kreadattrcontr

[GLOBAL klearscreen]
[GLOBAL scrollup]
[GLOBAL CRTBasePtr]
[GLOBAL kwaitvretrace]
[GLOBAL kopyfont]
[GLOBAL kgetfontaccess]
[GLOBAL kreleasefontaccess]
[GLOBAL kfontputpixel]
[GLOBAL klearfont]
[GLOBAL kselectcharmaps]
[GLOBAL kwriteattrcontr]
[GLOBAL kreadattrcontr]


; IMPLEMENTIERUNG DER FUNKTIONEN

[SECTION .text]


CRTBasePtr	dd	0xB8000
	
; klearscreen : fuellt den bildschirmspeicher mit zeichen/attribut
;
;       C-Prototyp: void klearscreen(char c, unsigned char attrib);

klearscreen:
	
	push	ebp
	mov	ebp,esp
	
	mov	edi,[CRTBasePtr]
	mov	ecx,1000	; 4000 bytes fuellen
	mov	al,[8+ebp]	; eax mit den parametern fuettern
	mov	ah,[12+ebp]
	shl	eax,16		; das war das hi-word
	mov	al,[8+ebp]	; lo-word auch
	mov	ah,[12+ebp]

	rep	stosd		; und los...

	pop	ebp

	ret

; scrollup : scrollt den bildschirm eine zeile hoch
;
;       C-Prototyp: void scrollup();

scrollup:

	mov esi,[CRTBasePtr]
	mov edi,esi
	add esi,0xA0
	mov	ecx,0x3E8-0x28		; ...24 zeilen moven
	rep	movsd
	
	mov	ecx,0x28			; 160 bytes
	mov	eax,(32 + COLOR_DEFAULT*256 + 32*65536 + COLOR_DEFAULT*256*65536)	; default color
	rep	stosd

	ret


; kwaitvretrace : wartet auf das eintreten des vertikalen strahlruecklaufs (retrace)
;
;		C-Prototyp: void kwaitvretrace();

kwaitvretrace:

	mov	dx,CRTSTATUS	
	
 	wait01:
	in	al,dx				; crt status lesen
	and al,0x08				; warten auf ende eines evtl. strahlruecklaufs
	jz	wait01
	
	wait02:
	in	al,dx				; warten auf das eintreten des strahlruecklaufs
	and	al,0x08
	jnz	wait02
	
	ret


; kgetfontaccess : ermoeglicht zugriff auf 2.bitplane (font-plane)
;
;       C-Prototyp: void kgetfontaccess( );	
kgetfontaccess:
	
	mov	dx,EGAVGA_SEQ		; einschalten des zugriffs auf die 2.bitplane
	mov	ax,0x0100
	out	dx,ax
	mov	ax,0x0402
	out	dx,ax
	mov	ax,0x0704
	out	dx,ax
	mov	ax,0x0300
	out dx,ax			; ...
	
	mov	dx,EGAVGA_GC
	mov	ax,0x0204
	out	dx,ax
	mov	ax,0x0005
	out	dx,ax
	mov	ax,0x0406
	out	dx,ax
	
	ret


; kreleasefontacces : macht wieder zugriff auf $B8000 moeglich
;
;       C-Prototyp: void kreleasefontacces( );	
kreleasefontaccess:
	mov	dx,EGAVGA_SEQ		; und zugriff wieder abschalten, weil sonst
	mov	ax,0x0100		; der zugriff auf 0xB8000 unmoeglich, da die
	out	dx,ax			; bitplanes 0 und 1 benutzt werden
	mov	ax,0x0302
	out	dx,ax
	mov	ax,0x0304
	out	dx,ax
	mov	ax,0x300
	out	dx,ax
	
	mov	dx,EGAVGA_GC		; ...
	mov	ax,0x0004
	out	dx,ax
	mov	ax,0x1005
	out	dx,ax
	mov	ax,0x0E06
	out	dx,ax
	
	ret	


; kopyfont : kopiert den ega-font aus der 2.bitplane des ega in buf
;
;       C-Prototyp: void kopyfont( void* buf );	
kopyfont:

	call kgetfontaccess
	
	mov	esi,0xA0000		; und kopieren
	mov	edi,[esp+0x04]
	
	mov	ecx,32*256
	rep	movsb
	
	call kreleasefontaccess
	
	ret

; kselectcharmaps : setzt die anzuzeigenden fonts
;
;	C-Prototyp: void kselectfontmaps( int map1, int map2 );
kselectcharmaps:
	
	push  ebp
	mov	  ebp,esp
	
	mov   dx,EGAVGA_SEQ
	mov   ax,0x0003
	mov   bl,[ebp+8]
	and   bl,0x03
	mov   ah,bl
	mov   bl,[ebp+12]
	and   bl,0x03
	shl   bl,0x02
	or    ah,bl
	mov   bl,[ebp+8]
	and   bl,0x04
	shl   bl,0x02
	or    ah,bl
	mov   bl,[ebp+12]
	and   bl,0x04
	shl   bl,0x03
	or    ah,bl
	out   dx,ax
	
	pop	  ebp
	
	ret


; kfontputpixel : setzt einen punkt in font fontptr, wobei davon ausgegangen wird, dass
; 				  das grafikfeld 32x8 zeichen umfasst
;
;	C-Prototyp: void kfontputpixel( void* fontptr, int x, int y );
kfontputpixel:

	push  ebp
	mov	  ebp,esp
	
	mov   esi,[ebp+08]
  	movzx eax,byte [ebp+16]
  	movzx ecx,byte [ebp+12]
  	mov   ebx,eax
  	and   bx,~0x0F
  	shl   bx,0x01
  	ror   ecx,0x03
  	add   bx,cx
  	shl   bx,0x05
  	and   ax,0x0F
  	or    bx,ax
  	mov   al,[esi+ebx]
  	rol   ecx,0x03
  	and   cl,0x07
  	mov   ah,0x80
  	shr   ah,cl
  	or    al,ah
  	mov   [esi+ebx],al
	
	pop	  ebp

	ret

; loescht den font in fontbuf
;
;	C_Prototyp: klearfont( void* fontbuf );
klearfont:

	push  ebp
	mov   ebp,esp
	
	mov	  edi,[ebp+08]
	mov	  ecx,0x2000/4
	xor	  eax,eax
	rep	  stosd
	
	pop	  ebp
	
	ret
	

kwriteattrcontr:

	push  ebp
	mov	  ebp,esp
	
	mov	  dx,CRTSTATUS
	in	  al,dx
	mov	  al,[ebp+8]
	mov	  dx,CRTATTR
	out   dx,al
	mov	  al,[ebp+12]
	out	  dx,al
	mov   al,0x20
	out   dx,al
	
	pop	  ebp
	
	ret
	
kreadattrcontr:

	push  ebp
	mov   ebp,esp
	
	mov   dx,CRTSTATUS
	in    al,dx
	mov   dx,CRTATTR
	mov   al,[ebp+8]
	out   dx,al
	inc   dx
	in    al,dx
	dec	  dx
	out   dx,al
	mov   bl,al
	mov   al,0x20
	out   dx,al
	movzx eax,bl
	
	pop   ebp
	
	ret
