/*****************************************************************************/
/* Betriebssysteme I, Uni Potsdam WS 99/00                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               P L U G                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul PLUG implementiert Funktionen, die fuer die Realisierung einer  */
/* Interrupt- oder Exception-Behandlung benoetigt werden.                    */
/*****************************************************************************/

/* INCLUDES */

#include "device/panic.h"
#include "machine/plug.h"


/* DEFINES */

#define NGATES 64

/* VARIABLEN DES MODULS */

static void (*box[NGATES])();


/* INIT_PLUG: Initialierung der Box mit Panic */

void
init_plug ()
{
	int i;
	for (i=0; i<NGATES; i++) {
		box[i] = panic_prologue;
	}
}

/* PLUG_ASSIGN: Eintragen einer Interruptroutine */

void
plug_assign (void (*handler)(), int entry)
{
	if (entry < NGATES)
		box[entry] = handler;
}


/* PLUG_REPORT: Abfrage einer Interruptroutine */

ptfrv
plug_report (int entry)
{
	if (entry < NGATES)
		return box[entry];
	return panic_prologue;
}
