/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97; Uni Potsdam WS 99/00             */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               P I C                                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul PIC implementiert Funktionen, die fuer die Realisierung einer   */
/* Interrupt- oder Exception-Behandlung benoetigt werden.                    */
/*****************************************************************************/

/* INCLUDES */

#include "machine/ioport.h"
#include "machine/pic.h"


/* GLOBALE VARIABLEN DES MODULS */

extern long* idt;


/* IMPLEMENTIERUNGEN DER EXPORTIERTEN FUNKTIONEN */

/* FORBID_INT : Unterdrueckt mit Hilfe des PICs einen bestimmten Hardware-   */
/*              Interrupt.                                                   */

void forbid_int (int no)
 {
   int mask;

   if (no < 8)          /* Hardware-Interrupt von PIC 1 */
    {
      mask = inb (0x21);
      outb (0x21, mask | (1 << no));
    }
   else                 /* Hardware-Interrupt von PIC 2 */
    {
      mask = inb (0xa1);
      outb (0xa1, mask | (1 << no));
    }
 }

/* ALLOW_INT : Erlaubt mit Hilfe des PIC einen bestimmen Hardware-Interrupt. */
/*             Damit die Unterbrechungsbehandlungsroutine fuer einen         */
/*             Hardware-Interrupt tatsaechlich ausgefuehrt wird, muss dies   */
/*             sowohl prozessorseitig ('enable_int') als auch durch den PIC  */
/*             ('allow_int') erlaubt sein.                                   */

void allow_int (int no)
 {
   int mask;

   if (no < 8)          /* Hardware-Interrupt von PIC 1 */
    {
      mask = inb (0x21);
      outb (0x21, mask & (~(1 << no)));
    }
   else                 /* Hardware-Interrupt von PIC 2 */
    {
      mask = inb (0xa1);
      outb (0xa1, mask & (~(1 << no)));
    }
 }


/* ACK : Dient dazu, innerhalb der Unterbrechungsbehandlung eines Hardware-  */
/*       Interrupts, dem PIC mitzuteilen, dass der letzte von ihm signali-   */
/*       sierte Interrupt nun behandelt wurde. 'ack' muss aufgerufen werden, */
/*       bevor prozessorseitig Unterbrechungen wieder zugelassen werden, da  */
/*       sonst eine erneute Unterbrechung fuer die selbe Anforderung ausge-  */
/*       loest werden wuerde.                                                */

void ack()
 {
   outb (0x20, 0x20); /* Unspez. EOI-Befehl an PIC 1 */
   outb (0xa0, 0x20); /* Unspez. EOI-Befehl an PIC 2 */
 }
