; INCLUDES

%include "include/csym.inc"	; Innerhalb des Include-Files 'csym.m4'
				; wird das Macro CSYM(name) definiert,
				; das dem uebergebenen Symbolnamen in
				; Abhaegigkeit vom verwendeten Generierungs-
				; system einen Unterstrich ('_') voranstellt.

%include "include/register.inc"


; EXPORTIERTE FUNKTIONEN

csym 		dispatch
csym		go

[GLOBAL dispatch]
[GLOBAL go]

; IMPLEMENTIERUNG DER FUNKTIONEN

[SECTION .text]

_eax	dd	0

dispatch:
	
	mov		[_eax],eax					; eax sichern
	mov		eax,[esp+0x04]				; offset von now nach eax
	mov		[eax+ebx_offset],ebx		; register sichern
	mov		[eax+ecx_offset],ecx
	mov		[eax+edx_offset],edx
	mov		[eax+ebp_offset],ebp
	mov		[eax+esi_offset],esi
	mov		[eax+edi_offset],edi
	mov		[eax+esp_offset],esp
	
	mov		ebx,[_eax]
	mov		[eax+eax_offset],ebx		; eax jetzt endlich auch retten
	
	mov		eax,[esp+0x08]				; offset von then nach eax
	mov		ebx,[eax+ebx_offset]		; register wieder herstellen
	mov		ecx,[eax+ecx_offset]
	mov		edx,[eax+edx_offset]
	mov		ebp,[eax+ebp_offset]
	mov		esi,[eax+esi_offset]
	mov		edi,[eax+edi_offset]
	mov		esp,[eax+esp_offset]
	mov		eax,[eax+eax_offset]
	
	ret									; und zum neuen process


; C-Prototyp: void go(struct register_set* regs);
go:
	mov		eax,[esp+4]
	mov		esp,[esp_offset+eax]
	
	ret
