;*****************************************************************************
;* Betriebssysteme I, Uni-Magdeburg, SS 97                                   *
;*---------------------------------------------------------------------------*
;*                                                                           *
;*                                I N T                                      *
;*                                                                           *
;*---------------------------------------------------------------------------*
;* Das Modul INT, das aus den Dateien INT.H, INT.C und INT_A.ASM besteht,    *
;* implementiert Funktionen, die fuer die Realisierung einer Interrupt- oder *
;* Exception-Behandlung benoetigt werden.                                    *
;*****************************************************************************


; INCLUDES

%include "include/csym.inc"	; Innerhalb des Include-Files 'csym.m4'


; EXPORTIERTE FUNKTIONEN

csym disable_int
csym enable_int
csym cpu_halt
 
[GLOBAL disable_int]
[GLOBAL enable_int]
[GLOBAL cpu_halt]


; IMPLEMENTIERUNG DER EXPORTIERTEN FUNKTIONEN

[SECTION .text]
		

; DISABLE_INT : Verbietet die Behandlung von Unterbrechungsanforderungen
;               prozessorseitig.                                      
;
;               C-Prototyp: void disable_int ();

disable_int:
	cli	; Interrupts werden durch einen CLI-Befehl verboten
	ret


; ENABLE_INT : Laesst prozessorseitig Unterbrechungen zu.
;
;              C-Prototyp: void enable_int ();

enable_int:
	sti	; Interrupts werden durch einen STI-Befehl wieder zugelassen
	ret


; CPU_HALT : Haelt den Prozessor an.
;
; C Prototyp: void cpu_halt (void)

cpu_halt:
        hlt
