#ifndef __screen_h__
#define __screen_h__

#include "machine/ioport.h"
#include "guard/sema.h"

extern struct semaphore screen_sema;  /* semaphore zur bildschirm synchronisation */

#define CGA_BASE 0xb8000
#define PORT_REG_INDEX 0x3d4
#define PORT_REG_DATA 0x3d5
#define REGINDEX_CURSOR_HIGH 14
#define REGINDEX_CURSOR_LOW 15

#define COLOR_FOREGROUND_BLACK	0
#define COLOR_FOREGROUND_BLUE	1
#define COLOR_FOREGROUND_GREEN	2
#define COLOR_FOREGROUND_CYAN	3
#define COLOR_FOREGROUND_RED	4
#define COLOR_FOREGROUND_MAGENTA	5
#define COLOR_FOREGROUND_BROWN	6
#define COLOR_FOREGROUND_LIGHTGREY	7
#define COLOR_FOREGROUND_DARKGREY	8
#define COLOR_FOREGROUND_LIGHTBLUE	9
#define COLOR_FOREGROUND_LIGHTGREEN	10
#define COLOR_FOREGROUND_LIGHTCYAN	11
#define COLOR_FOREGROUND_LIGHTRED	12
#define COLOR_FOREGROUND_LIGHTMAGENTA	13
#define COLOR_FOREGROUND_YELLOW	14
#define COLOR_FOREGROUND_WHITE	15
#define COLOR_BACKGROUND_BLACK	0
#define COLOR_BACKGROUND_BLUE	16
#define COLOR_BACKGROUND_GREEN	32
#define COLOR_BACKGROUND_CYAN	48
#define COLOR_BACKGROUND_RED	64
#define COLOR_BACKGROUND_MAGENTA	80
#define COLOR_BACKGROUND_BROWN	96
#define COLOR_BACKGROUND_LIGHTGREY	112
#define COLOR_BLINK	128

#define COLOR_DEFAULT	COLOR_BACKGROUND_BLUE | 7

/* schreibt direkt in den video-ram an die position x,y ein zeichen c mit
dem attribut attrib. die cursor position wird nicht veraendert */
int kshow(int x, int y, char c, unsigned char attrib);

/* gibt das zeichen an der angegebenen cursorposition zurueck */
char kgetChar(int x, int y);

/* gibt das attribut byte an der angegebenen cursorposition zurueck */
unsigned char kgetAttrib(int x, int y);


/* fuellt den gesamten bildschirm mit dem zeichen c und dem attribut attrib */
void klearscreen(char c, unsigned char attrib);

/* wartet auf das eintreten des vertikalen strahlenruecklaufs */
void kwaitvretrace();

/* gibt in x und y die aktuelle position des cursors zurueck */
void kgetpos(int* x, int* y);

/* setzt den cursor an die position x/y */
void ksetpos(int x, int y);

/* gibt an der aktuellen cursor-position den string text aus
passt der text nicht mehr auf die seite, wird der bildschirm entsprechend
hochgescrollt */
void kputs(const char* text);

/* kprintf funktioniert analog zu dem standard c printf, interpretiert werden
folgende %-direktiven:
%c - zeichen , %s - string , %x - hexadezimale zahl, %d - dezimale zahl,
%o - oktale zahl, %b - binaere zahl */
void kprintf(const char*, ...);

void kputBigLetter(int x, int y, char c, int fillc, int attrib, void* fnttbl);

void kputBigString(int x, int y, char* text, int fillc, int attrib, void* fnttbl);

void ksetpage(int page);

void kopyfont(void* buffer);

void kgetfontaccess();

void kreleasefontaccess();

void kselectcharmaps( int map1, int map2 );

void kfontputpixel( void* fontbuf, int x, int y );

void klearfont( void* fontbuf );

void kinitGraphRect( void* fontbuf, int x1, int y1, int width, int height, unsigned char attr );

void kwriteattrcontr( int index, int value );

int kreadattrcontr( int index );

#endif
