#ifndef __pic_include__
#define __pic_include__

/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97; Uni Potsdam WS 99/00             */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                P I C                                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul PIC implementiert Funktionen, die fuer die Realisierung einer   */
/* Interrupt- oder Exception-Behandlung benoetigt werden.                    */
/*****************************************************************************/


/* DEFINES */

/* Eintraege in der Interrupt-Vektortabelle. Diese Nummern werden fuer       */
/* 'plug_assign' benoetigt.                                              */

#define VEC_TIMER 32     /* Vektor fuer Timer-Interrupt                      */
#define VEC_KEYBD 33     /* Vektor fuer Tastatur-Interrupt                   */

/* Nummern der Hardware-Interrupts innerhalb der PICs. Diese Nummern sind    */
/* fuer 'forbid_int' und 'allow_int' zu verwenden.                           */

#define HW_INT_TIMER 0   /* Timer-Interrupt                                  */
#define HW_INT_KEYBD 1   /* Tastatur-Interrupt                               */

/* EXPORTIERTE FUNKTIONEN DES MODULS */

/* FORBID_INT : Unterdrueckt mit Hilfe des PICs einen bestimmten Hardware-   */
/*              Interrupt.                                                   */

void forbid_int (int no);

/* ALLOW_INT : Erlaubt mit Hilfe des PIC einen bestimmen Hardware-Interrupt. */
/*             Damit die Unterbrechungsbehandlungsroutine fuer einen         */
/*             Hardware-Interrupt tatsaechlich ausgefuehrt wird, muss dies   */
/*             sowohl prozessorseitig ('enable_int') als auch durch den PIC  */
/*             ('allow_int') erlaubt sein.                                   */

void allow_int (int no);

/* ACK : Dient dazu, innerhalb der Unterbrechungsbehandlung eines Hardware-  */
/*       Interrupts, dem PIC mitzuteilen, dass der letzte von ihm signali-   */
/*       sierte Interrupt nun behandelt wurde. 'ack' muss aufgerufen werden, */
/*       bevor prozessorseitig Unterbrechungen wieder zugelassen werden, da  */
/*       sonst eine erneute Unterbrechung fuer die selbe Anforderung ausge-  */
/*       loest werden wuerde.                                                */

void ack();

#endif
