#ifndef __pcb_include__
#define __pcb_include__

/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                P C B                                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Prozesskontrollblock des Systems.                                         */
/*****************************************************************************/

/* INCLUDES */

#include "machine/register.h"   /* Zu sichernder Teil des Registersatzes */
#include "objects/list.h"       /* Allgemeine Listenoperationen          */
#include "guard/sema.h"

/* STRUKTUREN */

/* moegliche Prozesszustaende */

enum process_state
 { RUNNING,   /* der Prozess laeuft */
   WAITING,	  /* der Prozess wartet auf ein Semaphor */
   READY      /* der Prozess ist lauffaehig */
 };


/* Prozesskontrollblock */

struct pcb
 {
   struct list_element chain;  /* Zeiger auf den naechsten Prozess           */
   struct register_set regs;   /* Registersatz                               */
   struct semaphore*   sema;   /* Zeiger auf das Semaphor				     */
   enum process_state state;   /* Prozesszustand                             */
 };

#endif


