#ifndef __keyctrl__include__
#define __keyctrl__include__

/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97; Uni Potsdam WS 99/00             */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          K E Y C T R L                                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul KEYCTRL, implementiert Funktionen, die fuer die Tastaturabfrage */
/* im Rahmen einer Unterbrechungsbehandlung und die Interpretation der       */
/* gesandten Codes benoetigt werden.                                         */
/*****************************************************************************/

/* DEFINES */

/* Portnummern fuer die Register des Tastaturcontrollers */

#define KEYBD_CTRL_PORT 0x64  /* Status- (R) u. Steuerregister (W) */
#define KEYBD_DATA_PORT 0x60  /* Ausgabe- (R) u. Eingabepuffer (W) */

/* Bit-Masken fuer die Modifier-Tasten */

#define MBIT_SHIFT         1
#define MBIT_ALT_LEFT      2
#define MBIT_ALT_RIGHT     4
#define MBIT_CTRL_LEFT     8
#define MBIT_CTRL_RIGHT   16
#define MBIT_CAPS_LOCK    32
#define MBIT_NUM_LOCK     64
#define MBIT_SCROLL_LOCK 128

/* Scan-Code der Delete-Taste */

#define SCAN_DELETE     0x53


/* EXPORTIERTE FUNKTIONEN DES MODULS */

/* REBOOT: Fuehrt ein Reset durch und loest damit ein Reboot aus.            */

void reboot ();

/* SET_REPEAT_RATE: Funktion zum Einstellen der Wiederholungsrate der        */
/*                  Tastatur.                                                */

void set_repeat_rate (int speed, int delay);

/* DECODE: Interpretiert die Make und Break-Codes der Tastatur und liefert   */
/*         den ASCII Code, den Scancode und Informationen darueber, welche   */
/*         zusaetzlichen Tasten wie Shift und Ctrl gedrueckt wurden.         */
/*         Ein Rueckgabewert != 0 bedeutet, dass das Zeichen komplett ist,   */
/*         anderenfalls fehlen noch Make oder Breakcodes.                    */

int decode (unsigned char key, 
	    char* ascii, char* scancode, char* modifiers);
#endif
