#ifndef __syscall_include__
#define __syscall_include__

/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                           S Y S C A L L                                   */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul SYSCALL, dass aus den Dateien SYSCALL.H und SYSCALL.C besteht,  */
/* implementiert die Systemaufrufschnittstelle des Uebungssystems. Alle      */
/* Systemaufrufe werden durch 'enter ()' und 'leave ()' mit Epilogen         */
/* synchronisert.                                                            */
/* Anwendungsprozesse sollte nur Funktionen diesen Moduls nutzen.            */
/* Einzige Ausnahme: Das SCREEN-Modul.                                       */
/*****************************************************************************/

/* INCLUDES */

#include "guard/sema.h"

/* EXPORTIERTE FUNKTIONEN DIESES MODULS */

/* Die einzelnen Funktionen des Moduls werden hier nicht kommentiert, da     */
/* es sich nur um Aufrufe gleichnamiger Funktionen (ohne 'sys_') handelt,    */
/* die durch 'enter ()' und 'leave ()' eingeschlossen wurden.                */


void sys_resume ();
int  sys_create_process (void (*code)(), char* stack, int stack_size);
void sys_kill_process (int pid);
void sys_exit_process ();

void sys_sema_init (struct semaphore *sema, int initial_counter);
void sys_sema_p (struct semaphore* sema);
void sys_sema_v (struct semaphore* sema);
void sys_sema_remove_proc (struct pcb *proc);

int  sys_getchar();
#endif
