#ifndef __sema_include__
#define __sema_include__

#include "objects/list.h"
#include "thread/process.h"

#define MAXSEMAS	MAXPROCS

/* STRUKTURDEFINITIONEN */

struct semaphore
 {
   struct list wait_list;
   int counter;
 };


/* initialisiert die elemente einer Semaphorvariablen */
void sema_init (struct semaphore *sema, int initial_counter);

/* warten auf ein semaphore */
void sema_p (struct semaphore* sema);

/* freigeben eines semaphores */
void sema_v (struct semaphore* sema);

/* enfernt einen prozess von der warteliste */
void sema_remove_proc (struct pcb *proc);

#endif
