#ifndef __lock_include__
#define __lock_include__

/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97; Uni Potsdam WS 99/00             */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               L O C K                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul LOCK dient der Synchronisation von Kernaktivitaeten auf Basis   */
/* von Pro- und Epilogen.                                                    */
/*****************************************************************************/

/* INCLUDES */

#include "objects/list.h"


/* STRUKTURDEFINITIONEN */

struct epilogue_descriptor
 {
   struct list_element chain;
   int queued;
   void (*epilogue)();
 };


/* EXPORTIERTE FUNKTIONEN DES MODULS */


/* INIT_LOCK: Initialiserungsfunktion des Moduls                             */

void init_lock ();


/* ENTER: Mit dem Aufruf von 'enter ()' wird angezeigt, dass jetzt eine      */
/*        Kernaktivitaet gestartet wird, die nicht von anderen Kernaktivi-   */
/*        taeten unterbrochen werden darf.                                   */

void enter ();


/* LEAVE: Beendet eine Kernaktivitaet und arbeitet die in der Zwischenzeit   */
/*        angestauten Epiloge ab.                                            */


void leave ();


/* RELAY: Gibt bekannt, dass ein bestimmter Epilog ausgefuehrt werden soll.  */
/*        Wenn zuvor im 'normalen' Kontrollfluss 'enter ()' aufgerufen       */
/*        wurde, wird der Epilog zur spaeteren Ausfuehrung in die Epilog-    */
/*        Queue gehaengt. Anderenfalls wird der Epilog sofort ausgefuehrt.   */
/*        'relay' wird aus dem Prolog heraus aufgerufen, d.h. Interrupts     */
/*        sind gesperrt. Im Rahmen von 'relay ()' werden die Interrupts wie- */
/*        der zugelassen.                                                    */

void relay (struct epilogue_descriptor *item);

#endif
