/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                           S Y S C A L L                                   */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul SYSCALL, dass aus den Dateien SYSCALL.H und SYSCALL.C besteht,  */
/* implementiert die Systemaufrufschnittstelle des Uebungssystems. Alle      */
/* Systemaufrufe werden durch 'enter ()' und 'leave ()' mit Epilogen         */
/* synchronisert.                                                            */
/* Anwendungsprozesse sollte nur Funktionen diesen Moduls nutzen.            */
/* Einzige Ausnahme: Das SCREEN-Modul.                                       */
/*****************************************************************************/

/* INCLUDES */

#include "device/keybd.h"
#include "guard/syscall.h"
#include "guard/lock.h"
#include "guard/sema.h"
#include "thread/sched.h"
#include "thread/process.h"

/* IMPLEMENTIERUNGEN DER EXPORTIERTEN FUNKTIONEN */

/* Die einzelnen Funktionen des Moduls werden hier nicht kommentiert, da     */
/* es sich nur um Aufrufe gleichnamiger Funktionen (ohne 'sys_') handelt,    */
/* die durch 'enter ()' und 'leave ()' eingeschlossen wurden.                */

void sys_resume ()
 {
   enter ();
   resume ();
   leave();
 }


int sys_create_process (void (*code)(), char* stack, int stack_size)
 {
   int pid;

   enter ();
   pid = create_process (code, stack, stack_size);
   leave ();
   return pid;
 }

void sys_kill_process (int pid)
 {
   enter ();
   kill_process (pid);
   leave ();
 }

void sys_exit_process ()
 {
   enter ();
   exit_process ();
   leave ();
 }

void sys_sema_p (struct semaphore* sema)
{
	enter();
	sema_p(sema);
	leave();
}

void sys_sema_v (struct semaphore* sema)
{
	enter();
	sema_v(sema);
	leave();
}

void sys_sema_remove_proc (struct pcb *proc)
{
	enter();
	sema_remove_proc(proc);
	leave();
}

void sys_sema_init (struct semaphore *sema, int initial_counter)
{
	enter();
	sema_init(sema,initial_counter);
	leave();
}


int sys_getchar()
{
	int key;
	
	enter();
	key = getchar();
	leave();
	return key;
}
