#include "machine/pcb.h"
#include "thread/sched.h"
#include "thread/process.h"
#include "guard/sema.h"
#include "objects/list.h"

void sema_init (struct semaphore *sema, int initial_counter)
{
	sema->counter = initial_counter;
	list_init(&sema->wait_list);
}

void sema_p (struct semaphore* sema)
{
	struct pcb* p;
		
	if ( sema->counter > 0 )
		sema->counter--;
	else {
		p = me();
		enqueue(&sema->wait_list,&p->chain);
		p->sema = sema;
		p->state = WAITING;
		remove_myself();
	}
}

void sema_v (struct semaphore* sema)
{
	struct pcb* p;
	
	if ( empty(&sema->wait_list) )
		sema->counter++;
	else {
		p = (struct pcb*)dequeue(&sema->wait_list);
		ready(p);
	}
}

void sema_remove_proc (struct pcb *proc)
{
	struct pcb* p = 0;
	int i;
	
	for ( i = 0; i <= MAXSEMAS; i++ ) {
		p = (struct pcb*)dequeue(&(proc->sema)->wait_list);
		if ( p == proc ) {
			p->sema = (struct semaphore*)0x00;
			return;
		}
		enqueue(&proc->sema->wait_list,&p->chain);
	}
}
