/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97; Uni Potsdam WS 99/00             */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               L O C K                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul LOCK dient der Synchronisation von Kernaktivitaeten auf Basis   */
/* von Pro- und Epilogen.                                                    */
/*****************************************************************************/

/* INCLUDES */

#include "guard/lock.h"
#include "machine/cpu.h"
#include "machine/screen.h"


/* DEKLARATION DER INTERNEN FUNKTIONEN DES MODULS */

struct epilogue_descriptor* remove_epilogue ();


/* GLOBALE VARIABLEN DES MODULS */

int lock;
struct list epilogue_queue;

/* IMPLEMENTIERUNGEN DER EXPORTIERTEN FUNKTIONEN */

/* INIT_LOCK: Initialiserungsfunktion des Moduls                             */

void init_lock ()
 {
   list_init (&epilogue_queue);
   lock = 0;
 }


/* ENTER: Mit dem Aufruf von 'enter ()' wird angezeigt, dass jetzt eine      */
/*        Kernaktivitaet gestartet wird, die nicht von anderen Kernaktivi-   */
/*        taeten unterbrochen werden darf.                                   */

void enter ()
 {
   lock++;
 }


/* LEAVE: Beendet eine Kernaktivitaet und arbeitet die in der Zwischenzeit   */
/*        angestauten Epiloge ab.                                            */

void leave ()
 {
   struct epilogue_descriptor* item;

   while ((item = remove_epilogue ()) != (struct epilogue_descriptor *) 0)
     {
       (*(item->epilogue))();
     }
   lock--;
 }

/* RELAY: Gibt bekannt, dass ein bestimmter Epilog ausgefuehrt werden soll.  */
/*        Wenn zuvor im 'normalen' Kontrollfluss 'enter ()' aufgerufen       */
/*        wurde, wird der Epilog zur spaeteren Ausfuehrung in die Epilog-    */
/*        Queue gehaengt. Anderenfalls wird der Epilog sofort ausgefuehrt.   */
/*        'relay' wird aus dem Prolog heraus aufgerufen, d.h. Interrupts     */
/*        sind gesperrt. Im Rahmen von 'relay ()' werden die Interrupts wie- */
/*        der zugelassen.                                                    */

void relay (struct epilogue_descriptor *item)
 {
   if (lock)
    {
      if (!item->queued){
	  enqueue (&epilogue_queue, &(item->chain));
	  item->queued = 1;
      }
      enable_int ();
    }
   else
    {
      enter();
      enable_int ();
      (*item->epilogue) ();
      leave();
    }
 }

/* IMPLEMENTIERUNGEN DER INTERNEN FUNKTIONEN */

/* REMOVE_EPILOGUE: Entnimmt einen Epilogue aus der Queue. Zur Synchronisa-  */
/*                  tion mit 'relay' werden Unterbrechungen kurzzeitig       */
/*                  verboten.                                                */

struct epilogue_descriptor* remove_epilogue ()
 {
   struct epilogue_descriptor* item;

   disable_int ();
   item = (struct epilogue_descriptor *)dequeue (&epilogue_queue);
   item->queued = 0;
   enable_int ();
   return item;
 }
