#include "machine/screen.h"

#define	MAXPOINTS	625
#define	FixBits		8
#define FixPoint	(1 << FixBits)

typedef	struct {
	int	x,y,z;
	}				Point3D;

typedef struct {
	int x,y;
	}				Point2D;
	
typedef	int			Matrix[9];

Matrix	Rotation;
/*Point3D	Points[MAXPOINTS];*/
Point2D	ScrPts[MAXPOINTS];

extern void rppoints(Matrix mat, Point3D* points, Point2D* dest, int num);

unsigned char	*fontbuf;
	
#include "sphere.inc"


void SetRotationMatrix( Matrix mat, int phix, int phiy, int phiz)
{
	int _sx, _sy, _sz;
    int	_cx, _cy, _cz;

  	_sx = SinusTab[phix & 0xFF];
  	_sy = SinusTab[phiy & 0xFF];
  	_sz = SinusTab[phiz & 0xFF];
  	_cx = SinusTab[(phix+64) & 0xFF];
  	_cy = SinusTab[(phiy+64) & 0xFF];
  	_cz = SinusTab[(phiz+64) & 0xFF];

  	mat[0] = (_cy * _cz) / FixPoint;
  	mat[1] = (_cy * _sz) / FixPoint;
  	mat[2] = -_sy;
  	mat[3] = ((_sx*_sy*_cz) / FixPoint - (_cx*_sz)) / FixPoint;
  	mat[4] = ((_sx*_sy*_sz) / FixPoint + (_cx*_cz)) / FixPoint;
  	mat[5] = (_sx*_cy) / FixPoint;
  	mat[6] = ((_cx*_sy*_cz) / FixPoint + (_sx*_sz)) / FixPoint;
  	mat[7] = ((_cx*_sy*_sz) / FixPoint - (_sx*_cz)) / FixPoint;
  	mat[8] = (_cx*_cy) / FixPoint;
}


void InitFun()
{
	fontbuf = (unsigned char*)0xA0000+0x4000;
	kselectcharmaps(0,1);
	kinitGraphRect(fontbuf, 64-32,20-8, 32,8, 4);
}


void DoFun( int counter )
{
	int j;

	kgetfontaccess();
	kwaitvretrace();
	klearfont(fontbuf);
	for ( j = 0; j < MAXPOINTS; j++ )
		kfontputpixel(fontbuf,ScrPts[j].x,ScrPts[j].y);
	kreleasefontaccess();
	 
	SetRotationMatrix(Rotation,counter,counter*2,counter/2);
	rppoints(Rotation,Sphere,ScrPts,MAXPOINTS);
}
