
#include "device/watch.h"
#include "machine/timer.h"
#include "machine/plug.h"
#include "machine/pic.h"
#include "machine/cpu.h"
#include "machine/screen.h"
#include "thread/sched.h"
#include "guard/lock.h"
#include "guard/syscall.h"

static struct epilogue_descriptor watch_epi;

void init_watch (void)
{
 watch_epi.epilogue = watch_epilogue;
 watch_epi.queued = 0;
 plug_assign(watch_prologue, VEC_TIMER);
 timer_set(20000);                /* 20000 = timer frequenz auf 20 millisekunden */
 allow_int(HW_INT_TIMER);
}

void watch_prologue (void)
{
 ack();
	
 relay(&watch_epi);
}

void watch_epilogue (void)
{
 resume();
}
