/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              L I S T                                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das Modul LIST, das aus den Dateien LIST.H und LIST.C besteht, implemen-  */
/* tiert eine einfach verkettete Liste.                                      */
/* Die Zugriffsfunktionen erlauben das Entfernen eines Elements vom Anfang   */
/* der Liste, das Anfuegen eines Elementes an das Ende der Liste und das     */
/* Loeschen eines angegebenen Elementes von einer beliebigen Position auf    */
/* der Liste. Listen muessen vor der ersten Benutzung initialisiert werden.  */
/*****************************************************************************/

/* INCLUDES */

#include "objects/list.h"


/* IMPLEMENTIERUNGEN DER EXPORTIERTEN FUNKTIONEN DIESES MODULS */

/* LIST_INIT : Initialisiert Head und Tailpointer der Liste. Der Tailpointer */
/*             ist ein Zeiger auf einen Zeiger auf ein Listenelement.        */
/*             So lange die Liste leer ist, zeigt der Tailpointer auf den    */
/*             Headpointer, spaeter, wenn die Liste Elemente enthaelt, zeigt */
/*             der Tailpointer auf den next-Pointer des letzten Listenele-   */
/*             ments. Das vereinfacht die Einfuegeoperation.                 */

void list_init (struct list *l)
 {
   l->head = (struct list_element*) 0;
   l->tail = &(l->head);
 }


/* LIST_ELEMENT_INIT : Initialisiert ein Listenelement. Der Next-Pointer     */
/*                     wird auf NULL gesetzt.                                */

void list_element_init (struct list_element* item)
 {
   item->next = (struct list_element*) 0;
 }


/* EMPTY : Liefert 1 zurueck, wenn die angegebene Liste leer ist, sonst 0.   */

int empty (struct list *l)
 {
   return (l->head == (struct list_element*) 0);
 }


/* ENQUEUE : Fuegt das angegebene Element an das Ende der Liste an. Da bei   */
/*           einer leeren Liste der Tailpointer auf den Headpointer zeigt,   */
/*           wird beim Einfuegen des ersten Elements auch der Headpointer    */
/*           automatisch richtig gesetzt.                                    */

void enqueue (struct list *l, struct list_element *item)
 {
   *(l->tail) = item;
   l->tail = &(item->next);
 }


/* DEQUEUE : Entfernt das erste Element aus der Liste. Wenn es das einzige   */
/*           Element der Liste war, muss der Tailpointer wieder auf den      */
/*           Headpointer gesetzt werden.                                     */

struct list_element *dequeue (struct list *l)
 {
   struct list_element* item;
   item = l->head;
   if (item)
    {
      l->head = item->next;
      if (l->head == (struct list_element*) 0)
	 l->tail = &(l->head);
      else
	item->next = (struct list_element*) 0;
    }
   return item;
 }


/* DELETE_ELEMENT : Loescht das angegebene Element aus der Liste. Dazu muss  */
/*                  die Liste nach dem Vorgaenger des Elements durchsucht    */
/*                  werden und dessen next-Pointer auf den Nachfolger des zu */
/*                  loeschenden den Elements gesetzt werden. War das zu      */
/*                  loeschende Element das erste oder letzte Element der     */
/*                  Liste, muessen auch Head- bzw. Tailpointer korrigiert    */
/*                  werden.                                                  */

struct list_element *delete_element (struct list *l, 
				     struct list_element *item)
 {
   struct list_element* curr;

   curr = l->head;
   if (curr == item)        /* das erste Element ist das gesuchtes Element */
    {
      l->head = item->next;                /* Element ausketten */
      if (l->head == (struct list_element*) 0)
	 l->tail = &(l->head);
      else
	 item->next = (struct list_element*) 0;
      return item;          /* ok, Element aus der Liste entfernt */
    }
   else                     /* Liste nach dem Vorgaenger durchsuchen */
     {
       while (curr && curr->next != item)
	 {
	   curr = curr->next;
	 }
       if (curr)            /* Vorgaenger gefunden */
	 {
	   curr->next = item->next;        /* Element ausketten */
	   if (curr->next == (struct list_element*) 0)
	     l->tail = &(curr->next);
	   else
	     item->next = (struct list_element*) 0;
	   return item;     /* ok, Element aus der Liste entfernt */
	 }
       else
	 return (struct list_element*) 0;   /* Element nicht gefunden */
     }
 }

